#include <stdio.h>
#include <kernel.h>
#include <string.h>
#include <tamtypes.h>
#include <malloc.h>
#include <sifrpc.h>
#include <loadfile.h>
#include <debug.h>
#include <iopcontrol.h>
#include <libcdvd.h>

/*
	This function provides an equivalent of the sceCdMV function from the newer CDVDMAN modules.
	When EELOADCNF is used (In the case of not resetting the IOP and the previous program used EELOADCNF), the data output won't be right because EELOADCNF causes XCDVDMAN to be used with the old CDVDFSV module.
	One extra byte will be returned to CDVDFSV when sceCdMV completes. It doesn't seem to cause a crash despite such a condition considered a buffer overflow, but the data returned to the EE will be wrong:
		The old specs (Followed by CDVDFSV and the EE-side client) mean that only 3 bytes should be returned instead of 4, so the returned data (to the EE-side program) will be offset by 1 and the trailing byte will be truncated.

	On the SCPH-10000 and SCPH-15000, EELOADCNF doesn't exist and hence this behaviour won't exist.
*/
int PrintMV()
{
	unsigned char in_buffer[1], out_buffer[4];
	int result;
	int stat = 0;

	memset(&out_buffer, 0, 4);

	in_buffer[0]=0;
	if((result=sceCdApplySCmd(0x03, in_buffer, sizeof(in_buffer), out_buffer, sizeof(out_buffer)))!=0)
	{
		stat=out_buffer[0];
		out_buffer[0]&=0x7F;
		scr_printf("\n\n\n  Mechacon version: 0x%02x%02x \n", out_buffer[1],out_buffer[2]);
	}

	return stat&0x80;
}

int PrintTemperature() {
	// Based on PS2Ident libxcdvd from SP193
	unsigned char in_buffer[1], out_buffer[16];
	int result;
	int stat = 0;

	memset(&out_buffer, 0, 16);

	in_buffer[0]= 0xEF;
	if((result=sceCdApplySCmd(0x03, in_buffer, sizeof(in_buffer), out_buffer, sizeof(out_buffer)))!=0)
		stat=out_buffer[0];

	if( !stat) {
		unsigned short temp = out_buffer[1] * 256 + out_buffer[2];
		scr_printf("  Temp: %2d.%2d  C \n",(temp - (temp%128)) / 128,(temp%128));
		return 1;
	}else{
		scr_printf("  Failed 0x03 0xEF command. stat=%x \n", stat);
		return 0;
	}

}


int main(int argc, char *argv[]) {
	SifInitRpc(0);
	SifIopReset("", 0);
	while(!SifIopSync()){}
	SifInitRpc(0);
	SifLoadFileInit();
	fioInit(); 

	init_scr();

	scr_printf("Reset IOP done. ");

	int ret;

	ret = SifLoadModule("rom0:SIO2MAN", 0, NULL);
	ret = SifLoadModule("rom0:CDVDMAN", 0, NULL);
	ret = SifLoadModule("rom0:CDVDFSV", 0, NULL);

	scr_printf("All modules loaded.\n");

	// for(ret = 0; ret < 10; ret++)
	do
	{
		scr_clear();
		PrintMV();
		PrintTemperature();
		PrintTemperature();
		sleep(3);
	}
	while(1);

	// SleepThread();

	return 0;
}
